<#macro registrationLayout bodyClass="" displayInfo=false displayMessage=true displayWide=false>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" class="${properties.kcHtmlClass!}">

<head>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="robots" content="noindex, nofollow">
    <meta name="theme-color" content="#fafafa">

    <#if properties.meta?has_content>
        <#list properties.meta?split(' ') as meta>
            <meta name="${meta?split('==')[0]}" content="${meta?split('==')[1]}"/>
        </#list>
    </#if>
    <title>${msg("loginTitle",(realm.displayName!''))}</title>
    <link rel="icon" href="${url.resourcesPath}/img/favicon.ico" sizes="48x48" />
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/semantic-ui/2.4.1/components/icon.min.css">
    <#if properties.styles?has_content>
        <#list properties.styles?split(' ') as style>
            <link href="${url.resourcesPath}/${style}" rel="stylesheet" />
        </#list>
    </#if>
</head>
<body>
    <div class="kc-flexbox-container">
        <div class="kc-flexbox-row-center">
            <div class="kc-brand">
                <img class="ui fluid image" src="${url.resourcesPath}/img/jumo_logo_filled_big.png" style="height: 96px;" draggable="false">
            </div>
        </div>
        <div class="ui one column grid container kc-flexbox-row-center">
            <div class="row">
                <div class="ui raised very padded text container segment kc-login-container">
                    <div class="three fields equal width stackable">
                        <div class="field"></div>
                        <div class="field kc-field-header">
                            <h3 class="ui centered aligned header"><#nested "header"></h3>
                        </div>
                        <div class="field" style="display: grid; justify-content: end;">
                            <#if realm.internationalizationEnabled  && locale.supported?size gt 1>
                                <div class="ui compact menu" tabindex="6">
                                    <div class="ui simple dropdown item">
                                        ${locale.current}
                                        <i class="dropdown icon"></i>
                                        <div class="menu">
                                            <#list locale.supported as l>
                                                <a href="${l.url}" class="item">${l.label}</a>
                                            </#list>
                                        </div>
                                    </div>
                                </div>
                            </#if>
                        </div>
                    </div>

                    <#if displayMessage && message?has_content>
                        <div class="ui mini ${message.type} message">
                            ${kcSanitize(message.summary)?no_esc}
                        </div>
                    </#if>

                    <#nested "form">

                    <div class="ui mini info message" id="firstVisit">
                        <div class="header">
                            ${msg("requestAccessTitle")}
                        </div>
                        <p>${msg("requestAccessThroughRegistration")}</p>
                    </div>

                    <div class="ui centered grid kc-field-new-user">
                        <#if displayInfo>
                            <#nested "info">
                        </#if>
                    </div>
                </div>
            </div>
        </div>
        <div class="kc-footer-wrapper">
            <div class="kc-footer-container">
                <h6 class="kc-copyright">
                    Copyright&nbsp;©&nbsp;<a href="http://www.jumo.de/">JUMO&nbsp;GmbH&nbsp;&&nbsp;Co.&nbsp;KG</a>,&nbsp;<script type="text/javascript">document.write(new Date().getFullYear());</script>
                </h6>
                <div class="kc-footer-links">
                    <a href="https://www.jumo.de/web/about-us/imprint">${msg("imprint")}</a>&nbsp;-&nbsp;<a href="https://www.jumo.de/web/about-us/privacynotice">${msg("privacyPolicy")}</a>
                </div>
            </div>
        </div>
    <#if properties.scripts?has_content>
        <#list properties.scripts?split(' ') as script>
            <script src="${url.resourcesPath}/${script}" type="text/javascript"></script>
        </#list>
    </#if>
    <#if scripts??>
        <#list scripts as script>
            <script src="${script}" type="text/javascript"></script>
        </#list>
    </#if>
</body>
</html>
</#macro>
