<title>Audako Authentication server</title>

<meta charset="utf-8">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta name="robots" content="noindex, nofollow">

<link rel="shortcut icon" href="${resourcesPath}/img/favicon.ico" type="image/x-icon">
<#if properties.styles?has_content>
    <#list properties.styles?split(' ') as style>
        <link href="${resourcesPath}/${style}" rel="stylesheet" />
    </#list>
</#if>
<div class="kc-wrapper">
    <div class="kc-brand-container">
        <div class="kc-brand"></div>
    </div>
    <div class="kc-navigation-container">
        <div class="ui raised very padded text container segment kc-navigation">
            <div class="ui two column center aligned grid">
                <div class="row">
                    <#if successMessage?has_content>
                        <div class="ui success message" style="width: 100%;">
                            <p><i class="check icon"></i> ${successMessage}</p>
                        </div>
                    <#elseif errorMessage?has_content>
                        <div class="ui error message" style="width: 100%;">
                            <p><i class="exclamation icon"></i> ${errorMessage}</p>
                        </div>
                    <#elseif bootstrap>
                        <#if localUser>
                            <div class="ui info message" style="width: 100%;">
                                <p><i class="icon user"></i> Please create an initial admin user to get started.</p>
                            </div>
                        <#else>
                            <div class="ui message" style="width: 100%;">
                                <div class="header">You need local access to create the initial admin user.</div>
                                <ul class="list">
                                    <li>Either open <a href="http://localhost:8080/auth">http://localhost:8080/auth</a></li>
                                    <li>or refer to the <a href="${properties.documentationUrl}">documentation</a> for further instructions.</li>
                                </ul>
                            </div>
                        </#if>
                    </#if>
                </div>
                <div class="middle aligned row">
                    <div class="column">
                        <div class="ui icon header">
                            <i class="user icon"></i>
                            <a href="${adminUrl}">Administration Console</a>
                        </div>
                        <p>Centrally manage all aspects of the Authentification on Audako</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="ui raised very padded text container segment kc-navigation">
            <div class="ui two column center aligned grid">
                <div class="middle aligned row">
                    <div class="column">
                        <div class="ui icon header">
                            <i class="book icon"></i>
                            <a>Documentation</a>
                        </div>
                        <p>User Guide</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="kc-footer-wrapper">
        <div class="kc-footer-container">
            <h6 class="kc-copyright">
                Copyright&nbsp;©&nbsp;<a href="http://www.jumo.de/">JUMO&nbsp;GmbH&nbsp;&&nbsp;Co.&nbsp;KG</a>,&nbsp;<script type="text/javascript">document.write(new Date().getFullYear());</script>
            </h6>
            <div class="kc-footer-links">
                <a href="https://www.jumo.de/web/about-us/imprint">Imprint</a>&nbsp;-&nbsp;<a href="https://www.jumo.de/web/about-us/privacynotice">Privacy Policy</a>
            </div>
        </div>
    </div>
</div>
